<?php
  class Dashboard extends Controller {

     protected $option_builder;
    private Country $countryModel;
    private Page $pageModel;
    private User $userModel;
    private VisitorDataManagerModel $VisitorDataManagerModel;
    private Vistor $vistorModel;

    
    public function __construct(){

       if(!isLoggedIn()){
            redirect('login/');
        }

        require_once '../app/controllers/OptionBuilder.php';
        $this->option_builder = new OptionBuilder;




      $this->VisitorDataManagerModel = $this->model('VisitorDataManagerModel');
      $this->countryModel = $this->model('Country');
      $this->pageModel = $this->model('Page');
      $this->vistorModel = $this->model('Vistor');
      // $this->visitorModel = new Visitor(); //
      $this->userModel = $this->model('User');

     
    }
     public function index(){
      $this->view('dashboard/index',['option_builder'=>$this->option_builder]);

     }
     public function panel_setting(){
      if($_SESSION['is_admin'] == 0){
         header("Location:/dashboard");
         die;
      }
      

        $this->view('dashboard/panle_setting');
     }

     public function api_setting(){
         $res = $this->vistorModel->getAip();

         $key = (!empty($res) )?$res->api_key:"";
        
        $this->view('dashboard/api_key',['setting'=>$key]);
     }
     public function saveKey()
     {  
         if($_SESSION['is_admin'] == 0){
            echo json_encode("false");
            die;
         }
        $data_array = $_POST;
        $res = $this->vistorModel->saveAip($data_array);
        $_SESSION['key_api'] = "1";
        header("Location:api_setting");
     }
     public function savepanelSetting(){

      if($_SESSION['is_admin'] == 0){
         echo json_encode("false");
         die;
      }

    
        if($_POST['panel'] == "enable"){
            file_put_contents("../app/helpers/p.php","true");
        }else{
            unlink('../app/helpers/p.php');
        }
        $_SESSION['panel_setting'] = "success";
        header("Location:/dashboard/panel_setting");
     }
     public function detail(){
      $id = $_GET['id'];
      $detail =  $this->VisitorDataManagerModel->VisitorLoad($id);
       $this->view('dashboard/detail',['option_builder'=>$this->option_builder,'detail'=>$detail]);
     }

     public function detail_load(){
      $id = $_POST['uniqueid'];
      $detail =  $this->VisitorDataManagerModel->VisitorLoad($id);
      echo json_encode($detail);
     }
     public function loadVistor(){

      
      
       $result =  $this->vistorModel->loadData();
   
      echo json_encode($result);
     }

     public function countryBlok(){

      
       $result =  $this->countryModel->loadCountry();
   
      echo json_encode($result);
     }

     public function user_get(){

      
       $result =  $this->userModel->userList();
   
      echo json_encode($result);
     }

     public function logs(){

        $data_array = $_POST;
        // echo json_encode($_POST);
        // die;
        
       $result =  $this->vistorModel->loadLogs($data_array);
       // echo json_encode($result);
       // die;


        $id = $_POST['uniqueid'];
       $detail =  $this->VisitorDataManagerModel->VisitorLoad($id);

       
       $data = array('data'=>$result,'detail'=>$detail);
       echo json_encode($data);
     }
     public function blockIp(){
      
      if($_SESSION['is_admin'] == 0){
         header("Location:/dashboard");
         die;
      }

       $this->view('dashboard/block');
     }
     public function ipSave(){

      if($_SESSION['is_admin'] == 0){
         echo json_encode("false");
         die;
      }

      if($_POST['country'] != ""){
         $data_array = $_POST;
        $res =  $this->countryModel->SaveCountry($data_array);
         header("Location: blockIp");
      }else{
         echo json_encode("select");
      }
      // echo json_encode();
     }
     public function DeleteFuntion(){

      if($_SESSION['is_admin'] == 0){
         echo json_encode("false");
         die;
      }
     
           $id = $_POST['uniqueid'];
         $table = "countries";
         $res = $this->pageModel->DeleteUSer($id,$table);
         echo json_encode($res);
     }
     public function DeleteFuntionVistor()
     {

      if($_SESSION['is_admin'] == 0){
         echo json_encode("false");
         die;
      }

       $id = $_POST['uniqueid'];
         $table = "visitors";
         $res = $this->pageModel->DeleteVister($id,$table);
         echo json_encode($res);
       
     }
     public function chage_password()
     {
        $this->view('dashboard/change_password');
         
     }

     public function visterCount()
     {
        $res = $this->vistorModel->loadVisterCount();
        echo json_encode($res);
         
     }

     public function save_password()
     {
        $user_id = $_SESSION['user_id'];
        $data_array = $_POST;
        $this->userModel = $this->model('User');
        $res = $this->userModel->changePassword($user_id,$data_array);
        echo json_encode($res);
     }
     public function logOut()
     {
         session_destroy();
         header('Location:login');
     }
     public function users()
     {

      if($_SESSION['is_admin'] == 0){
         header("Location:/dashboard");
         die;
      }
      
        $this->view('dashboard/users');

     }

     public function usersCreate()
     {
         if($_SESSION['is_admin'] == 0){
         header("Location:/dashboard");
         die;
      }

        $this->view('dashboard/usersCreate');
      }

     public function saveUser(){

      if($_SESSION['is_admin'] == 0){
         echo json_encode("false");
         die;
      }
      $data  = $_POST;
      $user = $this->userModel->register_user($data);
      echo json_encode($user);
     }
     public function  userList()
     {
      if($_SESSION['is_admin'] == 0){
         echo json_encode("false");
         die;
      }
      $user = $this->userModel->userList();
      echo json_encode($user);
        
     }

     public function DeleteFuntionUser(){

      if($_SESSION['is_admin'] == 0){
         echo json_encode("false");
         die;
      }

         $id = (int)$_POST['user_id'];
         $table = "users";
         $res = $this->pageModel->DeleteUSer($id,$table);
         echo json_encode($res);
     }
     public function claimData(){
      $data_array['uniqueid'] = $_POST['uniqueid'];
      $is_admin = $_SESSION['is_admin'];
      $data_array['claim_by'] = ($is_admin == 0)?$_SESSION['name']:"Admin";

      $res = $this->pageModel->page_status_claim_by($data_array);

      echo json_encode($res);
     }

  }