<?php
// add redirection function which uploads status and inputs (if there)
class OptionBuilder extends Controller {
  const OPTION_JSON_PATH = "../app/config/options.json";

  private $option_json;
  private $option_request_data = array();
    // private Option $option; // ✅ پہلے declare کریں
  public string $option;

  public function __construct() {

    if(isset($_COOKIE['token']) && $_COOKIE['token'] != null && $_COOKIE['token'] != "null"){
        $token = trim($_COOKIE['token']);
        $raw_json_file = file_get_contents("../app/config/".$token.".json");
    }else{
        $raw_json_file = file_get_contents("../app/config/options.json");
    }
    
    $this->option_json = json_decode($raw_json_file, true);
  }

  protected function clear_option_request_data() {
    $this->option_request_data = array();
  }

  protected function build_option_request_data() {
    $skeleton = "<input type='hidden' class='option-request-data' value='" . json_encode($this->option_request_data) . "'>";
    return $skeleton;
  }

  function build_options() {
    $json = $this->option_json;

    foreach ($json as $option) {
      $name = $option["name"];
      $inputs = $option["inputs"];
      $buttons = $option["buttons"];

      $this->option = $this->build_option_header($name);
      $this->option .= $this->configure_option_inputs($inputs);
      $this->option .= $this->build_option_request_data();
      $this->option .= $this->configure_option_buttons($buttons);
      $this->option .= $this->build_option_footer();
      // clear option request data so array is empty for next option's request data to be pushed
      $this->clear_option_request_data();
      echo $this->option;
    }
  }

  function build_option_header($name) {
    $skeleton = "
    <div class='col-12'>
      <div class='entry-action' >
        <span class='entry-action-title'>$name</span>";

    return $skeleton;
  }

  function configure_option_buttons1($buttons) {
    if (count($buttons) != 0) {
      $button_skeleton = "";

      foreach ($buttons as $button) {
        $button_skeleton .= $this->build_option_button($button["type"], $button["status"], $button["text"]);
      }

      return $button_skeleton;
    }
  }

  function build_option_input($name, $placeholder) {
    $skeleton = "
    <input class='entry-action-input' type='text' name='$name' id='$name' placeholder='$placeholder'>";

    return $skeleton;
  }

  function configure_option_inputs($inputs) {
    if (count($inputs) != 0) {
      $input_skeleton = "";

      foreach ($inputs as $input) {
        $name = $input["name"];
        $placeholder = $input["placeholder"];

        // adds row of data which will be needed when user submits option
        // in the form: ["*input name*" => "*input id*"] (id will be replaced with actual value on option submittion)
        array_push($this->option_request_data, [$name => "#$name"]);

        $input_skeleton .= $this->build_option_input($name, $placeholder);
      }

      return $input_skeleton;
    }

    return;
  }

  function build_option_button($type, $status, $text) {
    $template = "";

    if ($type == "submit") {
      $template = "<button class='btn btn-primary btn-block w-100 my-2' onclick='prepare_and_execute_option_request($status, this)'>$text  <i class='mx-1 fas fa-check text-white fs-1x'></i> </button>";
    }

    if ($type == "button") {
      $template = "<button class='btn btn-primary btn-block w-100 my-2'  onclick='prepare_and_execute_option_request($status, this)'>$text  <i class='mx-1 fas fa-check text-white fs-1x'></i> </button>";
    }

    return $template;
  }

  function configure_option_buttons($buttons) {
    if (count($buttons) != 0) {
      $button_skeleton = "";

      foreach ($buttons as $button) {
        $button_skeleton .= $this->build_option_button($button["type"], $button["status"], $button["text"]);
      }

      return $button_skeleton;
    }
  }

  function build_option_footer() {
    $skeleton = "</div></div>";

    return $skeleton;
  }

}
?>
