<?php

class User {

	private $db;
    public function __construct()
    {
        $this->db = new Database;
    }
	public function register($data){

        $this->db->query('SELECT * FROM users WHERE username = :id');
        $this->db->bind(':id', $data['username']);
        $row = $this->db->single();
        $this->db->rowCount();
        if($this->db->rowCount() > 0){
            return "user already";
        }
        $password =  password_hash($data['password'], PASSWORD_DEFAULT);
		$this->db->query('INSERT INTO users (username, password, is_admin) VALUES (:name, :pass_word, :is_admin)');
        $this->db->bind(':name', $data['username']);
        $this->db->bind(':pass_word', $password);
        $this->db->bind(':is_admin', true);
        if($this->db->execute()){
            file_put_contents('../app/config/install.php',time());
            return true;
        }else{
            return false;
        }
	}
    public function changePassword($user_id,$data_array)
    {
        $this->db->query('SELECT * FROM users WHERE id = :id');
        $this->db->bind(':id', $user_id);
        $row = $this->db->single();
        $hash_mathc = password_verify($data_array['current_password'], $row->password);
        if($hash_mathc === false){
            return "match";
        }
        if($data_array['new_password'] != $data_array['confirm_password']){
            return "current";
        }
         $password_new =  password_hash($data_array['new_password'], PASSWORD_DEFAULT);
         $this->db->query('UPDATE users SET password = :password WHERE id = :userid');
         $this->db->bind(':userid',$user_id);
         $this->db->bind(':password',$password_new);
         $this->db->execute();
         return "update";
        
    }

    public function register_user($data){

        $this->db->query('SELECT * FROM users WHERE username = :id');
        $this->db->bind(':id', $data['username']);
        $row = $this->db->single();
        $this->db->rowCount();
        if($this->db->rowCount() > 0){
            return "user already";
        }
        $password =  password_hash($data['password'], PASSWORD_DEFAULT);
        $this->db->query('INSERT INTO users (username, password, is_admin) VALUES (:name, :pass_word, :is_admin)');
        $this->db->bind(':name', $data['username']);
        $this->db->bind(':pass_word', $password);
        $this->db->bind(':is_admin', false);
        if($this->db->execute()){
            return "ok";
        }else{
            return "not";
        }
    }
     public function userList(){

        $this->db->query('SELECT * FROM users');
        // $this->db->execute();
        $result = $this->db->resultSet();
        
        $order_id = 1;
        foreach ($result as $value) {
            $value->RecordID = $value->id;
            $value->OrderID = "49349-38".$order_id++;

            $value->username = $value->username;
            $value->RecordID = $value->id;
            $value->OrderID = "49349-38".$value->id;
        }
        
        $count = count($result);
        $data = array('recordsTotal'=>$count,'recordsFiltered'=>$count,'data'=>$result);
        return $data;
     }
}